#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nonce
version:              1.0.7
visibility:           public
id:                   nonce-1.0.7-BD5Nic8fPjxDN1Iaklhkv3
key:                  nonce-1.0.7-BD5Nic8fPjxDN1Iaklhkv3
license:              BSD-3-Clause
copyright:            (c) 2014 Prowdsponsor
maintainer:           Prowdsponsor <opensource@prowdsponsor.com>
author:               Felipe Lessa <felipe.lessa@prowdsponsor.com>
homepage:             https://github.com/prowdsponsor/nonce
synopsis:             Generate cryptographic nonces.
description:
    According to the Wikipedia, a nonce is an arbitrary number used
    only once in a cryptographic communication.  This package
    contain helper functions for generating nonces.

    There are many kinds of nonces used in different situations.
    It'\''s not guaranteed that by using the nonces from this package
    you won'\''t have any security issues.  Please make sure that the
    nonces generated via this package are usable on your design.

category:             Cryptography
abi:                  28082e3596753af00331b1b0b84f8165
exposed:              True
exposed-modules:      Crypto.Nonce
import-dirs:          /usr/lib/ghc-9.2.8/site-local/nonce-1.0.7
library-dirs:         /usr/lib/ghc-9.2.8/site-local/nonce-1.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-nonce
hs-libraries:         HSnonce-1.0.7-BD5Nic8fPjxDN1Iaklhkv3
depends:
    base-4.16.4.0 base64-bytestring-1.2.1.0-10uzYZsf0KVKU2D9qeaVY8
    bytestring-0.11.4.0 entropy-0.4.1.11-8g1240oEX98G9ng2a56xRZ
    text-1.2.5.0 transformers-0.5.6.2
    unliftio-0.2.25.1-8L6BiCnh80y1RfJtEqTngb
    unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn

haddock-interfaces:   /usr/share/doc/haskell-nonce/html/nonce.haddock
haddock-html:         /usr/share/doc/haskell-nonce/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

